/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.eventmon.email;

import com.ibm.hwmca.fw.eventmon.email.EmailException;
import com.ibm.hwmca.fw.eventmon.email.SMTPConstants;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.StringTokenizer;

public class Emailer
implements SMTPConstants {
    private static final String TRACE_MASKT = "XNTYEMAT";
    private static final String TRACE_MASKF = "XNTYEMAF";
    private static final String TRACE_MASKD = "XNTYEMAD";
    private String hostname;
    private int port;
    private Socket s;

    public static void main(String[] args) throws Exception {
        Emailer email = new Emailer("relay.us.ibm.com", 25);
        email.send("colegl@us.ibm.com", "colegl@us.ibm.com", "testing 123", "This is only a test.");
    }

    public Emailer(String hostname, int port) throws IllegalArgumentException, EmailException {
        if (hostname == null || hostname.trim().equals("")) {
            throw new IllegalArgumentException(hostname);
        }
        if (port < 0) {
            throw new IllegalArgumentException(new Integer(port).toString());
        }
        Trace.trace(TRACE_MASKT, "<> Emailer: " + hostname + ", " + port);
        this.hostname = hostname;
        this.port = port;
        try {
            this.s = new Socket(InetAddress.getByName(hostname), port);
        }
        catch (Exception e) {
            throw new EmailException(e);
        }
    }

    private void connect() throws EmailException {
        Trace.trace(TRACE_MASKT, "<> connect()");
        try {
            this.s = new Socket(InetAddress.getByName(this.hostname), this.port);
        }
        catch (Exception e) {
            throw new EmailException(e);
        }
    }

    public void close() throws EmailException {
        Trace.trace(TRACE_MASKT, "<> close()");
        try {
            this.s.close();
            this.s = null;
        }
        catch (Exception e) {
            throw new EmailException(e);
        }
    }

    public void send(String to, String from, String subject, String message) throws EmailException {
        Trace.trace(TRACE_MASKT, "-> send()");
        if (this.s == null) {
            this.connect();
        }
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        try {
            bis = new BufferedInputStream(this.s.getInputStream());
            bos = new BufferedOutputStream(this.s.getOutputStream());
            try {
                this.hello(bis, bos);
                this.sendFrom(from, bis, bos);
                this.sendTo(to, bis, bos);
                this.sendData(to, from, subject, message, bis, bos);
                this.goodbye(bis, bos);
            }
            catch (EmailException e) {
                try {
                    this.goodbye(bis, bos);
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw e;
            }
        }
        catch (Exception e) {
            throw new EmailException(e);
        }
        Trace.trace(TRACE_MASKT, "<- send()");
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (Exception e) {}
    }

    private void hello(InputStream in, OutputStream out) throws EmailException {
        Trace.trace(TRACE_MASKT, "-> hello()");
        try {
            byte[] buffer = new byte[1024];
            in.read(buffer);
            int code = Emailer.getCodeAsInt(buffer);
            if (code != 220) {
                throw new EmailException(new String(buffer), code);
            }
            Trace.trace(TRACE_MASKD, "they're ready for us");
            String helloString = "HELO " + InetAddress.getLocalHost().getHostName() + "\r\n";
            Trace.trace(TRACE_MASKD, "helloString: " + helloString);
            out.write(helloString.getBytes());
            out.flush();
            Trace.trace(TRACE_MASKD, "we said hello");
            in.read(buffer);
            code = Emailer.getCodeAsInt(buffer);
            if (code != 250 && code != 220) {
                throw new EmailException(new String(buffer), code);
            }
        }
        catch (Exception e) {
            throw new EmailException(e);
        }
        Trace.trace(TRACE_MASKT, "<- hello()");
    }

    private void sendFrom(String from, InputStream in, OutputStream out) throws EmailException {
        Trace.trace(TRACE_MASKT, "-> sendFrom()");
        try {
            byte[] buffer = new byte[1024];
            String fromString = "MAIL FROM:<" + from + ">" + "\r\n";
            Trace.trace(TRACE_MASKD, "fromString: " + fromString);
            out.write(fromString.getBytes());
            out.flush();
            Trace.trace(TRACE_MASKD, "we sent our mail from command");
            in.read(buffer);
            int code = Emailer.getCodeAsInt(buffer);
            if (code != 250) {
                throw new EmailException(new String(buffer), code);
            }
        }
        catch (Exception e) {
            throw new EmailException(e);
        }
        Trace.trace(TRACE_MASKT, "<- sendFrom()");
    }

    private void sendTo(String to, InputStream in, OutputStream out) throws EmailException {
        Trace.trace(TRACE_MASKT, "-> sendTo()");
        try {
            byte[] buffer = new byte[1024];
            String toString = "RCPT TO:<" + to + ">" + "\r\n";
            Trace.trace(TRACE_MASKD, "toString: " + toString);
            out.write(toString.getBytes());
            out.flush();
            Trace.trace(TRACE_MASKD, "we sent our mail to command");
            in.read(buffer);
            int code = Emailer.getCodeAsInt(buffer);
            if (code != 250) {
                throw new EmailException(new String(buffer), code);
            }
        }
        catch (Exception e) {
            throw new EmailException(e);
        }
        Trace.trace(TRACE_MASKT, "<- sendTo()");
    }

    private void sendData(String to, String from, String subject, String message, InputStream in, OutputStream out) throws EmailException {
        Trace.trace(TRACE_MASKT, "-> sendData()");
        try {
            byte[] buffer = new byte[1024];
            String dataString = "DATA\r\n";
            out.write(dataString.getBytes());
            out.flush();
            Trace.trace(TRACE_MASKD, "we sent our data command");
            in.read(buffer);
            int code = Emailer.getCodeAsInt(buffer);
            if (code != 354 && code != 250) {
                throw new EmailException(new String(buffer), code);
            }
            Trace.trace(TRACE_MASKD, "They're ready for the mail");
            dataString = "To: " + to + "\r\n";
            out.write(dataString.getBytes());
            dataString = "From: " + from + "\r\n";
            out.write(dataString.getBytes());
            dataString = "Subject: " + subject + "\r\n";
            out.write(dataString.getBytes());
            dataString = message;
            out.write(dataString.getBytes());
            dataString = "\r\n.\r\n";
            out.write(dataString.getBytes());
            out.flush();
            Trace.trace(TRACE_MASKD, "we spewed out our message");
            in.read(buffer);
            code = Emailer.getCodeAsInt(buffer);
            if (code != 250 && code != 354) {
                throw new EmailException(new String(buffer), code);
            }
        }
        catch (Exception e) {
            throw new EmailException(e);
        }
        Trace.trace(TRACE_MASKT, "<- sendData()");
    }

    private void goodbye(InputStream in, OutputStream out) throws EmailException {
        Trace.trace(TRACE_MASKT, "-> goodbye()");
        try {
            byte[] buffer = new byte[1024];
            String quitString = "QUIT\r\n";
            Trace.trace(TRACE_MASKD, "quitString: " + quitString);
            out.write(quitString.getBytes());
            out.flush();
            Trace.trace(TRACE_MASKD, "we said we want to quit");
            in.read(buffer);
            int code = Emailer.getCodeAsInt(buffer);
            if (code != 221 && code != 250) {
                throw new EmailException(new String(buffer), code);
            }
        }
        catch (Exception e) {
            throw new EmailException(e);
        }
        Trace.trace(TRACE_MASKT, "<- goodbye()");
    }

    private static int getCodeAsInt(byte[] buffer) {
        String s = new String(buffer).trim();
        Trace.trace(TRACE_MASKF, "getCodeAsInt:  buffer is '" + s + "'");
        StringTokenizer st = new StringTokenizer(s, " -");
        String returnCodeString = st.nextToken();
        Trace.trace(TRACE_MASKF, "getCodeAsInt:  returnCodeString is '" + returnCodeString + "'");
        return Integer.parseInt(returnCodeString);
    }
}

